/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;

public class Region
implements Cloneable,
Comparable,
Serializable {
    private String name;
    private String abbreviation;
    private static final long serialVersionUID = 5641130361130944628L;
    private static final String TRACE_MASKT = "XCDICRYT";
    private static final String TRACE_MASKF = "XCDICRYF";
    private static final String TRACE_MASKD = "XCDICRYD";

    public Region(String name, String abbreviation) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> Region() - " + name + ", " + abbreviation);
        if (name == null) {
            String msg = "Name parameter can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        if (abbreviation == null) {
            String msg = "Abbreviation parameter can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        if (abbreviation.length() != 2) {
            String msg = "The abbreviation >" + abbreviation + "< is not 2 characters";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        this.name = name.trim();
        this.abbreviation = abbreviation.toUpperCase();
        Trace.trace(TRACE_MASKT, "<- Region()");
    }

    public int compareTo(Region anotherRegion) {
        return this.getName().compareTo(anotherRegion.getName());
    }

    public int compareTo(Object o) {
        return this.compareTo((Region)o);
    }

    public String toString() {
        return this.name + "," + this.abbreviation;
    }

    public Object clone() {
        Trace.trace(TRACE_MASKT, "-> Region.clone()");
        Region copy = null;
        try {
            copy = (Region)super.clone();
        }
        catch (CloneNotSupportedException e) {
            copy = null;
            Trace.trace(TRACE_MASKF, " - Region.clone() - catch CloneNotSupportedException");
        }
        copy.name = new String(this.name);
        copy.abbreviation = new String(this.abbreviation);
        Trace.trace(TRACE_MASKT, "<- Region.clone()");
        return copy;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getName() {
        return this.name;
    }

    public static Region findRegionByName(Region[] regionList, String regionName) throws IllegalArgumentException, HException {
        Trace.trace(TRACE_MASKT, "-> Region.findRegionByName() - " + regionName);
        if (regionList == null) {
            String msg = "regionList argument was null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        if (regionName == null) {
            String msg = "regionName argument was null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String tempName = regionName.trim();
        boolean found = false;
        Region foundRegion = null;
        if (tempName.length() == 0) {
            foundRegion = new Region("", "  ");
            found = true;
        } else {
            for (int i = 0; i < regionList.length; ++i) {
                if (!tempName.equals(regionList[i].getName())) continue;
                foundRegion = regionList[i];
                found = true;
                break;
            }
        }
        if (!found) {
            String msg = "Region " + regionName + " does not exist in data supplied";
            HException he = new HException(msg);
            throw he;
        }
        Trace.trace(TRACE_MASKT, "<- Region.findRegionByName() - " + foundRegion);
        return foundRegion;
    }
}

